package loquebot.util;

/**
 * Static part of this class is responsible for issuing unique ID numbers, which
 * are suitable for requests into the engine (e.g. reachability checks, get path
 * requests, etc.).
 *
 * Non-static part of this class provides a simple ID wrapper, which is suitable
 * for synchronization purposes between requests and responses.
 *
 * @author Juraj Simlovic [jsimlo@matfyz.cz]
 * @version Tested on Pogamut 2 platform version 1.0.5.
 */
public class LoqueRequestID
{
    /**
     * Current ID used for request into engine.
     */
    public int ID = -1;

    /**
     * Applies for a new ID and stores this ID in {@link #ID}.
     * @param count Number of subsequent requests that are going to be made.
     * @return Unique ID suitable for requests to engine. This ID, and all
     * subsequent numbers upto <i>ID + count - 1</i> are safe to be used.
     */
    public int createNewID (int count)
    {
        return ID = LoqueRequestID.nextID(count);
    }

    /*========================================================================*/

    /**
     * Next ID to be issued.
     */
    private static int nextID = 1;

    /**
     * Synchronization object;
     */
    private static Object sync = new Object ();

    /**
     * Retreives new unique ID suitable for requests to engine.
     * @param count Number of subsequent requests that are going to be made.
     * @return Unique ID suitable for requests to engine. This ID, and all
     * subsequent numbers upto <i>ID + count - 1</i> are safe to be used.
     */
    public static int nextID (int count)
    {
        synchronized (sync)
        {
            int result = nextID;
            nextID += count;
            return result;
        }
    }
}
